/*
 * This declarations of the PIC16C926 MCU.
 *
 * This file is part of the GNU PIC library for SDCC, originally
 * created by Molnar Karoly <molnarkaroly@users.sf.net> 2012.
 *
 * This file is generated automatically by the cinc2h.pl, 2012-11-01 17:29:55 UTC.
 *
 * SDCC is licensed under the GNU Public license (GPL) v2. Note that
 * this license covers the code to the compiler and other executables,
 * but explicitly does not cover any code or objects generated by sdcc.
 *
 * For pic device libraries and header files which are derived from
 * Microchip header (.inc) and linker script (.lkr) files Microchip
 * requires that "The header files should state that they are only to be
 * used with authentic Microchip devices" which makes them incompatible
 * with the GPL. Pic device libraries and header files are located at
 * non-free/lib and non-free/include directories respectively.
 * Sdcc should be run with the --use-non-free command line option in
 * order to include non-free header files and libraries.
 *
 * See http://sdcc.sourceforge.net/ for the latest information on sdcc.
 */

#ifndef __PIC16C926_H__
#define __PIC16C926_H__

//==============================================================================
//
//	Register Addresses
//
//==============================================================================

#ifndef NO_ADDR_DEFINES

#define INDF_ADDR               0x0000
#define TMR0_ADDR               0x0001
#define PCL_ADDR                0x0002
#define STATUS_ADDR             0x0003
#define FSR_ADDR                0x0004
#define PORTA_ADDR              0x0005
#define PORTB_ADDR              0x0006
#define PORTC_ADDR              0x0007
#define PORTD_ADDR              0x0008
#define PORTE_ADDR              0x0009
#define PCLATH_ADDR             0x000A
#define INTCON_ADDR             0x000B
#define PIR1_ADDR               0x000C
#define TMR1_ADDR               0x000E
#define TMR1L_ADDR              0x000E
#define TMR1H_ADDR              0x000F
#define T1CON_ADDR              0x0010
#define TMR2_ADDR               0x0011
#define T2CON_ADDR              0x0012
#define SSPBUF_ADDR             0x0013
#define SSPCON_ADDR             0x0014
#define CCPR1_ADDR              0x0015
#define CCPR1L_ADDR             0x0015
#define CCPR1H_ADDR             0x0016
#define CCP1CON_ADDR            0x0017
#define ADRESH_ADDR             0x001E
#define ADCON0_ADDR             0x001F
#define OPTION_REG_ADDR         0x0081
#define TRISA_ADDR              0x0085
#define TRISB_ADDR              0x0086
#define TRISC_ADDR              0x0087
#define TRISD_ADDR              0x0088
#define TRISE_ADDR              0x0089
#define PIE1_ADDR               0x008C
#define PCON_ADDR               0x008E
#define PR2_ADDR                0x0092
#define SSPADD_ADDR             0x0093
#define SSPSTAT_ADDR            0x0094
#define ADRESL_ADDR             0x009E
#define ADCON1_ADDR             0x009F
#define PORTF_ADDR              0x0107
#define PORTG_ADDR              0x0108
#define PMCON1_ADDR             0x010C
#define LCDSE_ADDR              0x010D
#define LCDPS_ADDR              0x010E
#define LCDCON_ADDR             0x010F
#define LCDD00_ADDR             0x0110
#define LCDD01_ADDR             0x0111
#define LCDD02_ADDR             0x0112
#define LCDD03_ADDR             0x0113
#define LCDD04_ADDR             0x0114
#define LCDD05_ADDR             0x0115
#define LCDD06_ADDR             0x0116
#define LCDD07_ADDR             0x0117
#define LCDD08_ADDR             0x0118
#define LCDD09_ADDR             0x0119
#define LCDD10_ADDR             0x011A
#define LCDD11_ADDR             0x011B
#define LCDD12_ADDR             0x011C
#define LCDD13_ADDR             0x011D
#define LCDD14_ADDR             0x011E
#define LCDD15_ADDR             0x011F
#define TRISF_ADDR              0x0187
#define TRISG_ADDR              0x0188
#define PMDATA_ADDR             0x018C
#define PMADR_ADDR              0x018D
#define PMDATH_ADDR             0x018E
#define PMADRH_ADDR             0x018F

#endif // #ifndef NO_ADDR_DEFINES

//==============================================================================
//
//	Register Definitions
//
//==============================================================================

extern __at(0x0000) __sfr INDF;
extern __at(0x0001) __sfr TMR0;
extern __at(0x0002) __sfr PCL;

//==============================================================================
//        STATUS Bits

extern __at(0x0003) __sfr STATUS;

typedef union
  {
  struct
    {
    unsigned C                  : 1;
    unsigned DC                 : 1;
    unsigned Z                  : 1;
    unsigned NOT_PD             : 1;
    unsigned NOT_TO             : 1;
    unsigned RP0                : 1;
    unsigned RP1                : 1;
    unsigned IRP                : 1;
    };

  struct
    {
    unsigned                    : 5;
    unsigned RP                 : 2;
    unsigned                    : 1;
    };
  } __STATUSbits_t;

extern __at(0x0003) volatile __STATUSbits_t STATUSbits;

#define _C                      0x01
#define _DC                     0x02
#define _Z                      0x04
#define _NOT_PD                 0x08
#define _NOT_TO                 0x10
#define _RP0                    0x20
#define _RP1                    0x40
#define _IRP                    0x80

//==============================================================================

extern __at(0x0004) __sfr FSR;

//==============================================================================
//        PORTA Bits

extern __at(0x0005) __sfr PORTA;

typedef union
  {
  struct
    {
    unsigned RA0                : 1;
    unsigned RA1                : 1;
    unsigned RA2                : 1;
    unsigned RA3                : 1;
    unsigned RA4                : 1;
    unsigned RA5                : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned RA                 : 6;
    unsigned                    : 2;
    };
  } __PORTAbits_t;

extern __at(0x0005) volatile __PORTAbits_t PORTAbits;

#define _RA0                    0x01
#define _RA1                    0x02
#define _RA2                    0x04
#define _RA3                    0x08
#define _RA4                    0x10
#define _RA5                    0x20

//==============================================================================


//==============================================================================
//        PORTB Bits

extern __at(0x0006) __sfr PORTB;

typedef struct
  {
  unsigned RB0                  : 1;
  unsigned RB1                  : 1;
  unsigned RB2                  : 1;
  unsigned RB3                  : 1;
  unsigned RB4                  : 1;
  unsigned RB5                  : 1;
  unsigned RB6                  : 1;
  unsigned RB7                  : 1;
  } __PORTBbits_t;

extern __at(0x0006) volatile __PORTBbits_t PORTBbits;

#define _RB0                    0x01
#define _RB1                    0x02
#define _RB2                    0x04
#define _RB3                    0x08
#define _RB4                    0x10
#define _RB5                    0x20
#define _RB6                    0x40
#define _RB7                    0x80

//==============================================================================


//==============================================================================
//        PORTC Bits

extern __at(0x0007) __sfr PORTC;

typedef union
  {
  struct
    {
    unsigned RC0                : 1;
    unsigned RC1                : 1;
    unsigned RC2                : 1;
    unsigned RC3                : 1;
    unsigned RC4                : 1;
    unsigned RC5                : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned RC                 : 6;
    unsigned                    : 2;
    };
  } __PORTCbits_t;

extern __at(0x0007) volatile __PORTCbits_t PORTCbits;

#define _RC0                    0x01
#define _RC1                    0x02
#define _RC2                    0x04
#define _RC3                    0x08
#define _RC4                    0x10
#define _RC5                    0x20

//==============================================================================


//==============================================================================
//        PORTD Bits

extern __at(0x0008) __sfr PORTD;

typedef struct
  {
  unsigned RD0                  : 1;
  unsigned RD1                  : 1;
  unsigned RD2                  : 1;
  unsigned RD3                  : 1;
  unsigned RD4                  : 1;
  unsigned RD5                  : 1;
  unsigned RD6                  : 1;
  unsigned RD7                  : 1;
  } __PORTDbits_t;

extern __at(0x0008) volatile __PORTDbits_t PORTDbits;

#define _RD0                    0x01
#define _RD1                    0x02
#define _RD2                    0x04
#define _RD3                    0x08
#define _RD4                    0x10
#define _RD5                    0x20
#define _RD6                    0x40
#define _RD7                    0x80

//==============================================================================


//==============================================================================
//        PORTE Bits

extern __at(0x0009) __sfr PORTE;

typedef struct
  {
  unsigned RE0                  : 1;
  unsigned RE1                  : 1;
  unsigned RE2                  : 1;
  unsigned RE3                  : 1;
  unsigned RE4                  : 1;
  unsigned RE5                  : 1;
  unsigned RE6                  : 1;
  unsigned RE7                  : 1;
  } __PORTEbits_t;

extern __at(0x0009) volatile __PORTEbits_t PORTEbits;

#define _RE0                    0x01
#define _RE1                    0x02
#define _RE2                    0x04
#define _RE3                    0x08
#define _RE4                    0x10
#define _RE5                    0x20
#define _RE6                    0x40
#define _RE7                    0x80

//==============================================================================

extern __at(0x000A) __sfr PCLATH;

//==============================================================================
//        INTCON Bits

extern __at(0x000B) __sfr INTCON;

typedef union
  {
  struct
    {
    unsigned RBIF               : 1;
    unsigned INTF               : 1;
    unsigned T0IF               : 1;
    unsigned RBIE               : 1;
    unsigned INTE               : 1;
    unsigned T0IE               : 1;
    unsigned PEIE               : 1;
    unsigned GIE                : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned TMR0IF             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned TMR0IE             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __INTCONbits_t;

extern __at(0x000B) volatile __INTCONbits_t INTCONbits;

#define _RBIF                   0x01
#define _INTF                   0x02
#define _T0IF                   0x04
#define _TMR0IF                 0x04
#define _RBIE                   0x08
#define _INTE                   0x10
#define _T0IE                   0x20
#define _TMR0IE                 0x20
#define _PEIE                   0x40
#define _GIE                    0x80

//==============================================================================


//==============================================================================
//        PIR1 Bits

extern __at(0x000C) __sfr PIR1;

typedef struct
  {
  unsigned TMR1IF               : 1;
  unsigned TMR2IF               : 1;
  unsigned CCP1IF               : 1;
  unsigned SSPIF                : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned ADIF                 : 1;
  unsigned LCDIF                : 1;
  } __PIR1bits_t;

extern __at(0x000C) volatile __PIR1bits_t PIR1bits;

#define _TMR1IF                 0x01
#define _TMR2IF                 0x02
#define _CCP1IF                 0x04
#define _SSPIF                  0x08
#define _ADIF                   0x40
#define _LCDIF                  0x80

//==============================================================================

extern __at(0x000E) __sfr TMR1;
extern __at(0x000E) __sfr TMR1L;
extern __at(0x000F) __sfr TMR1H;

//==============================================================================
//        T1CON Bits

extern __at(0x0010) __sfr T1CON;

typedef union
  {
  struct
    {
    unsigned TMR1ON             : 1;
    unsigned TMR1CS             : 1;
    unsigned NOT_T1SYNC         : 1;
    unsigned T1OSCEN            : 1;
    unsigned T1CKPS0            : 1;
    unsigned T1CKPS1            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned T1INSYNC           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 4;
    unsigned T1CKPS             : 2;
    unsigned                    : 2;
    };
  } __T1CONbits_t;

extern __at(0x0010) volatile __T1CONbits_t T1CONbits;

#define _TMR1ON                 0x01
#define _TMR1CS                 0x02
#define _NOT_T1SYNC             0x04
#define _T1INSYNC               0x04
#define _T1OSCEN                0x08
#define _T1CKPS0                0x10
#define _T1CKPS1                0x20

//==============================================================================

extern __at(0x0011) __sfr TMR2;

//==============================================================================
//        T2CON Bits

extern __at(0x0012) __sfr T2CON;

typedef union
  {
  struct
    {
    unsigned T2CKPS0            : 1;
    unsigned T2CKPS1            : 1;
    unsigned TMR2ON             : 1;
    unsigned TOUTPS0            : 1;
    unsigned TOUTPS1            : 1;
    unsigned TOUTPS2            : 1;
    unsigned TOUTPS3            : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned T2CKPS             : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 3;
    unsigned TOUTPS             : 4;
    unsigned                    : 1;
    };
  } __T2CONbits_t;

extern __at(0x0012) volatile __T2CONbits_t T2CONbits;

#define _T2CKPS0                0x01
#define _T2CKPS1                0x02
#define _TMR2ON                 0x04
#define _TOUTPS0                0x08
#define _TOUTPS1                0x10
#define _TOUTPS2                0x20
#define _TOUTPS3                0x40

//==============================================================================

extern __at(0x0013) __sfr SSPBUF;

//==============================================================================
//        SSPCON Bits

extern __at(0x0014) __sfr SSPCON;

typedef union
  {
  struct
    {
    unsigned SSPM0              : 1;
    unsigned SSPM1              : 1;
    unsigned SSPM2              : 1;
    unsigned SSPM3              : 1;
    unsigned CKP                : 1;
    unsigned SSPEN              : 1;
    unsigned SSPOV              : 1;
    unsigned WCOL               : 1;
    };

  struct
    {
    unsigned SSPM               : 4;
    unsigned                    : 4;
    };
  } __SSPCONbits_t;

extern __at(0x0014) volatile __SSPCONbits_t SSPCONbits;

#define _SSPM0                  0x01
#define _SSPM1                  0x02
#define _SSPM2                  0x04
#define _SSPM3                  0x08
#define _CKP                    0x10
#define _SSPEN                  0x20
#define _SSPOV                  0x40
#define _WCOL                   0x80

//==============================================================================

extern __at(0x0015) __sfr CCPR1;
extern __at(0x0015) __sfr CCPR1L;
extern __at(0x0016) __sfr CCPR1H;

//==============================================================================
//        CCP1CON Bits

extern __at(0x0017) __sfr CCP1CON;

typedef union
  {
  struct
    {
    unsigned CCP1M0             : 1;
    unsigned CCP1M1             : 1;
    unsigned CCP1M2             : 1;
    unsigned CCP1M3             : 1;
    unsigned CCP1Y              : 1;
    unsigned CCP1X              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CCP1M              : 4;
    unsigned                    : 4;
    };
  } __CCP1CONbits_t;

extern __at(0x0017) volatile __CCP1CONbits_t CCP1CONbits;

#define _CCP1M0                 0x01
#define _CCP1M1                 0x02
#define _CCP1M2                 0x04
#define _CCP1M3                 0x08
#define _CCP1Y                  0x10
#define _CCP1X                  0x20

//==============================================================================

extern __at(0x001E) __sfr ADRESH;

//==============================================================================
//        ADCON0 Bits

extern __at(0x001F) __sfr ADCON0;

typedef union
  {
  struct
    {
    unsigned ADON               : 1;
    unsigned                    : 1;
    unsigned GO_NOT_DONE        : 1;
    unsigned CHS0               : 1;
    unsigned CHS1               : 1;
    unsigned CHS2               : 1;
    unsigned ADCS0              : 1;
    unsigned ADCS1              : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned GO                 : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned NOT_DONE           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned GO_DONE            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 3;
    unsigned CHS                : 3;
    unsigned                    : 2;
    };

  struct
    {
    unsigned                    : 6;
    unsigned ADCS               : 2;
    };
  } __ADCON0bits_t;

extern __at(0x001F) volatile __ADCON0bits_t ADCON0bits;

#define _ADON                   0x01
#define _GO_NOT_DONE            0x04
#define _GO                     0x04
#define _NOT_DONE               0x04
#define _GO_DONE                0x04
#define _CHS0                   0x08
#define _CHS1                   0x10
#define _CHS2                   0x20
#define _ADCS0                  0x40
#define _ADCS1                  0x80

//==============================================================================


//==============================================================================
//        OPTION_REG Bits

extern __at(0x0081) __sfr OPTION_REG;

typedef union
  {
  struct
    {
    unsigned PS0                : 1;
    unsigned PS1                : 1;
    unsigned PS2                : 1;
    unsigned PSA                : 1;
    unsigned T0SE               : 1;
    unsigned T0CS               : 1;
    unsigned INTEDG             : 1;
    unsigned NOT_RBPU           : 1;
    };

  struct
    {
    unsigned PS                 : 3;
    unsigned                    : 5;
    };
  } __OPTION_REGbits_t;

extern __at(0x0081) volatile __OPTION_REGbits_t OPTION_REGbits;

#define _PS0                    0x01
#define _PS1                    0x02
#define _PS2                    0x04
#define _PSA                    0x08
#define _T0SE                   0x10
#define _T0CS                   0x20
#define _INTEDG                 0x40
#define _NOT_RBPU               0x80

//==============================================================================


//==============================================================================
//        TRISA Bits

extern __at(0x0085) __sfr TRISA;

typedef union
  {
  struct
    {
    unsigned TRISA0             : 1;
    unsigned TRISA1             : 1;
    unsigned TRISA2             : 1;
    unsigned TRISA3             : 1;
    unsigned TRISA4             : 1;
    unsigned TRISA5             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned TRISA              : 6;
    unsigned                    : 2;
    };
  } __TRISAbits_t;

extern __at(0x0085) volatile __TRISAbits_t TRISAbits;

#define _TRISA0                 0x01
#define _TRISA1                 0x02
#define _TRISA2                 0x04
#define _TRISA3                 0x08
#define _TRISA4                 0x10
#define _TRISA5                 0x20

//==============================================================================


//==============================================================================
//        TRISB Bits

extern __at(0x0086) __sfr TRISB;

typedef struct
  {
  unsigned TRISB0               : 1;
  unsigned TRISB1               : 1;
  unsigned TRISB2               : 1;
  unsigned TRISB3               : 1;
  unsigned TRISB4               : 1;
  unsigned TRISB5               : 1;
  unsigned TRISB6               : 1;
  unsigned TRISB7               : 1;
  } __TRISBbits_t;

extern __at(0x0086) volatile __TRISBbits_t TRISBbits;

#define _TRISB0                 0x01
#define _TRISB1                 0x02
#define _TRISB2                 0x04
#define _TRISB3                 0x08
#define _TRISB4                 0x10
#define _TRISB5                 0x20
#define _TRISB6                 0x40
#define _TRISB7                 0x80

//==============================================================================


//==============================================================================
//        TRISC Bits

extern __at(0x0087) __sfr TRISC;

typedef union
  {
  struct
    {
    unsigned TRISC0             : 1;
    unsigned TRISC1             : 1;
    unsigned TRISC2             : 1;
    unsigned TRISC3             : 1;
    unsigned TRISC4             : 1;
    unsigned TRISC5             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned TRISC              : 6;
    unsigned                    : 2;
    };
  } __TRISCbits_t;

extern __at(0x0087) volatile __TRISCbits_t TRISCbits;

#define _TRISC0                 0x01
#define _TRISC1                 0x02
#define _TRISC2                 0x04
#define _TRISC3                 0x08
#define _TRISC4                 0x10
#define _TRISC5                 0x20

//==============================================================================


//==============================================================================
//        TRISD Bits

extern __at(0x0088) __sfr TRISD;

typedef struct
  {
  unsigned TRISD0               : 1;
  unsigned TRISD1               : 1;
  unsigned TRISD2               : 1;
  unsigned TRISD3               : 1;
  unsigned TRISD4               : 1;
  unsigned TRISD5               : 1;
  unsigned TRISD6               : 1;
  unsigned TRISD7               : 1;
  } __TRISDbits_t;

extern __at(0x0088) volatile __TRISDbits_t TRISDbits;

#define _TRISD0                 0x01
#define _TRISD1                 0x02
#define _TRISD2                 0x04
#define _TRISD3                 0x08
#define _TRISD4                 0x10
#define _TRISD5                 0x20
#define _TRISD6                 0x40
#define _TRISD7                 0x80

//==============================================================================


//==============================================================================
//        TRISE Bits

extern __at(0x0089) __sfr TRISE;

typedef union
  {
  struct
    {
    unsigned TRISE0             : 1;
    unsigned TRISE1             : 1;
    unsigned TRISE2             : 1;
    unsigned TRISE3             : 1;
    unsigned TRISE4             : 1;
    unsigned TRISE5             : 1;
    unsigned TRISE6             : 1;
    unsigned TRISE7             : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned PSPMODE            : 1;
    unsigned IBOV               : 1;
    unsigned OBF                : 1;
    unsigned IBF                : 1;
    };
  } __TRISEbits_t;

extern __at(0x0089) volatile __TRISEbits_t TRISEbits;

#define _TRISE0                 0x01
#define _TRISE1                 0x02
#define _TRISE2                 0x04
#define _TRISE3                 0x08
#define _TRISE4                 0x10
#define _PSPMODE                0x10
#define _TRISE5                 0x20
#define _IBOV                   0x20
#define _TRISE6                 0x40
#define _OBF                    0x40
#define _TRISE7                 0x80
#define _IBF                    0x80

//==============================================================================


//==============================================================================
//        PIE1 Bits

extern __at(0x008C) __sfr PIE1;

typedef struct
  {
  unsigned TMR1IE               : 1;
  unsigned TMR2IE               : 1;
  unsigned CCP1IE               : 1;
  unsigned SSPIE                : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned ADIE                 : 1;
  unsigned LCDIE                : 1;
  } __PIE1bits_t;

extern __at(0x008C) volatile __PIE1bits_t PIE1bits;

#define _TMR1IE                 0x01
#define _TMR2IE                 0x02
#define _CCP1IE                 0x04
#define _SSPIE                  0x08
#define _ADIE                   0x40
#define _LCDIE                  0x80

//==============================================================================


//==============================================================================
//        PCON Bits

extern __at(0x008E) __sfr PCON;

typedef struct
  {
  unsigned NOT_BOR              : 1;
  unsigned NOT_POR              : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __PCONbits_t;

extern __at(0x008E) volatile __PCONbits_t PCONbits;

#define _NOT_BOR                0x01
#define _NOT_POR                0x02

//==============================================================================

extern __at(0x0092) __sfr PR2;
extern __at(0x0093) __sfr SSPADD;

//==============================================================================
//        SSPSTAT Bits

extern __at(0x0094) __sfr SSPSTAT;

typedef union
  {
  struct
    {
    unsigned BF                 : 1;
    unsigned UA                 : 1;
    unsigned R_NOT_W            : 1;
    unsigned S                  : 1;
    unsigned P                  : 1;
    unsigned D_NOT_A            : 1;
    unsigned CKE                : 1;
    unsigned SMP                : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned R                  : 1;
    unsigned I2C_START          : 1;
    unsigned I2C_STOP           : 1;
    unsigned D                  : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned I2C_READ           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned I2C_DATA           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned R_W                : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned D_A                : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned READ_WRITE         : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned DATA_ADDRESS       : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned NOT_W              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned NOT_A              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned NOT_WRITE          : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned NOT_ADDRESS        : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __SSPSTATbits_t;

extern __at(0x0094) volatile __SSPSTATbits_t SSPSTATbits;

#define _BF                     0x01
#define _UA                     0x02
#define _R_NOT_W                0x04
#define _R                      0x04
#define _I2C_READ               0x04
#define _R_W                    0x04
#define _READ_WRITE             0x04
#define _NOT_W                  0x04
#define _NOT_WRITE              0x04
#define _S                      0x08
#define _I2C_START              0x08
#define _P                      0x10
#define _I2C_STOP               0x10
#define _D_NOT_A                0x20
#define _D                      0x20
#define _I2C_DATA               0x20
#define _D_A                    0x20
#define _DATA_ADDRESS           0x20
#define _NOT_A                  0x20
#define _NOT_ADDRESS            0x20
#define _CKE                    0x40
#define _SMP                    0x80

//==============================================================================

extern __at(0x009E) __sfr ADRESL;

//==============================================================================
//        ADCON1 Bits

extern __at(0x009F) __sfr ADCON1;

typedef union
  {
  struct
    {
    unsigned PCFG0              : 1;
    unsigned PCFG1              : 1;
    unsigned PCFG2              : 1;
    unsigned PCFG3              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned ADFM               : 1;
    };

  struct
    {
    unsigned PCFG               : 4;
    unsigned                    : 4;
    };
  } __ADCON1bits_t;

extern __at(0x009F) volatile __ADCON1bits_t ADCON1bits;

#define _PCFG0                  0x01
#define _PCFG1                  0x02
#define _PCFG2                  0x04
#define _PCFG3                  0x08
#define _ADFM                   0x80

//==============================================================================


//==============================================================================
//        PORTF Bits

extern __at(0x0107) __sfr PORTF;

typedef struct
  {
  unsigned RF0                  : 1;
  unsigned RF1                  : 1;
  unsigned RF2                  : 1;
  unsigned RF3                  : 1;
  unsigned RF4                  : 1;
  unsigned RF5                  : 1;
  unsigned RF6                  : 1;
  unsigned RF7                  : 1;
  } __PORTFbits_t;

extern __at(0x0107) volatile __PORTFbits_t PORTFbits;

#define _RF0                    0x01
#define _RF1                    0x02
#define _RF2                    0x04
#define _RF3                    0x08
#define _RF4                    0x10
#define _RF5                    0x20
#define _RF6                    0x40
#define _RF7                    0x80

//==============================================================================


//==============================================================================
//        PORTG Bits

extern __at(0x0108) __sfr PORTG;

typedef struct
  {
  unsigned RG0                  : 1;
  unsigned RG1                  : 1;
  unsigned RG2                  : 1;
  unsigned RG3                  : 1;
  unsigned RG4                  : 1;
  unsigned RG5                  : 1;
  unsigned RG6                  : 1;
  unsigned RG7                  : 1;
  } __PORTGbits_t;

extern __at(0x0108) volatile __PORTGbits_t PORTGbits;

#define _RG0                    0x01
#define _RG1                    0x02
#define _RG2                    0x04
#define _RG3                    0x08
#define _RG4                    0x10
#define _RG5                    0x20
#define _RG6                    0x40
#define _RG7                    0x80

//==============================================================================


//==============================================================================
//        PMCON1 Bits

extern __at(0x010C) __sfr PMCON1;

typedef struct
  {
  unsigned RD                   : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __PMCON1bits_t;

extern __at(0x010C) volatile __PMCON1bits_t PMCON1bits;

#define _RD                     0x01

//==============================================================================


//==============================================================================
//        LCDSE Bits

extern __at(0x010D) __sfr LCDSE;

typedef struct
  {
  unsigned SE0                  : 1;
  unsigned SE5                  : 1;
  unsigned SE9                  : 1;
  unsigned SE12                 : 1;
  unsigned SE16                 : 1;
  unsigned SE20                 : 1;
  unsigned SE27                 : 1;
  unsigned SE29                 : 1;
  } __LCDSEbits_t;

extern __at(0x010D) volatile __LCDSEbits_t LCDSEbits;

#define _SE0                    0x01
#define _SE5                    0x02
#define _SE9                    0x04
#define _SE12                   0x08
#define _SE16                   0x10
#define _SE20                   0x20
#define _SE27                   0x40
#define _SE29                   0x80

//==============================================================================


//==============================================================================
//        LCDPS Bits

extern __at(0x010E) __sfr LCDPS;

typedef union
  {
  struct
    {
    unsigned LP0                : 1;
    unsigned LP1                : 1;
    unsigned LP2                : 1;
    unsigned LP3                : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned LP                 : 4;
    unsigned                    : 4;
    };
  } __LCDPSbits_t;

extern __at(0x010E) volatile __LCDPSbits_t LCDPSbits;

#define _LP0                    0x01
#define _LP1                    0x02
#define _LP2                    0x04
#define _LP3                    0x08

//==============================================================================


//==============================================================================
//        LCDCON Bits

extern __at(0x010F) __sfr LCDCON;

typedef union
  {
  struct
    {
    unsigned LMUX0              : 1;
    unsigned LMUX1              : 1;
    unsigned CS0                : 1;
    unsigned CS1                : 1;
    unsigned VGEN               : 1;
    unsigned WERR               : 1;
    unsigned SLPEN              : 1;
    unsigned LCDEN              : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned BIAS               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned LMUX               : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 2;
    unsigned CS                 : 2;
    unsigned                    : 4;
    };
  } __LCDCONbits_t;

extern __at(0x010F) volatile __LCDCONbits_t LCDCONbits;

#define _LMUX0                  0x01
#define _LMUX1                  0x02
#define _CS0                    0x04
#define _CS1                    0x08
#define _VGEN                   0x10
#define _BIAS                   0x10
#define _WERR                   0x20
#define _SLPEN                  0x40
#define _LCDEN                  0x80

//==============================================================================


//==============================================================================
//        LCDD00 Bits

extern __at(0x0110) __sfr LCDD00;

typedef struct
  {
  unsigned SEG00                : 1;
  unsigned SEG01                : 1;
  unsigned SEG02                : 1;
  unsigned SEG03                : 1;
  unsigned SEG04                : 1;
  unsigned SEG05                : 1;
  unsigned SEG06                : 1;
  unsigned SEG07                : 1;
  } __LCDD00bits_t;

extern __at(0x0110) volatile __LCDD00bits_t LCDD00bits;

#define _SEG00                  0x01
#define _SEG01                  0x02
#define _SEG02                  0x04
#define _SEG03                  0x08
#define _SEG04                  0x10
#define _SEG05                  0x20
#define _SEG06                  0x40
#define _SEG07                  0x80

//==============================================================================


//==============================================================================
//        LCDD01 Bits

extern __at(0x0111) __sfr LCDD01;

typedef struct
  {
  unsigned SEG08                : 1;
  unsigned SEG09                : 1;
  unsigned SEG10                : 1;
  unsigned SEG11                : 1;
  unsigned SEG12                : 1;
  unsigned SEG13                : 1;
  unsigned SEG14                : 1;
  unsigned SEG15                : 1;
  } __LCDD01bits_t;

extern __at(0x0111) volatile __LCDD01bits_t LCDD01bits;

#define _SEG08                  0x01
#define _SEG09                  0x02
#define _SEG10                  0x04
#define _SEG11                  0x08
#define _SEG12                  0x10
#define _SEG13                  0x20
#define _SEG14                  0x40
#define _SEG15                  0x80

//==============================================================================


//==============================================================================
//        LCDD02 Bits

extern __at(0x0112) __sfr LCDD02;

typedef struct
  {
  unsigned SEG16                : 1;
  unsigned SEG17                : 1;
  unsigned SEG18                : 1;
  unsigned SEG19                : 1;
  unsigned SEG20                : 1;
  unsigned SEG21                : 1;
  unsigned SEG22                : 1;
  unsigned SEG23                : 1;
  } __LCDD02bits_t;

extern __at(0x0112) volatile __LCDD02bits_t LCDD02bits;

#define _SEG16                  0x01
#define _SEG17                  0x02
#define _SEG18                  0x04
#define _SEG19                  0x08
#define _SEG20                  0x10
#define _SEG21                  0x20
#define _SEG22                  0x40
#define _SEG23                  0x80

//==============================================================================


//==============================================================================
//        LCDD03 Bits

extern __at(0x0113) __sfr LCDD03;

typedef struct
  {
  unsigned SEG24                : 1;
  unsigned SEG25                : 1;
  unsigned SEG26                : 1;
  unsigned SEG27                : 1;
  unsigned SEG28                : 1;
  unsigned SEG29                : 1;
  unsigned SEG30                : 1;
  unsigned SEG31                : 1;
  } __LCDD03bits_t;

extern __at(0x0113) volatile __LCDD03bits_t LCDD03bits;

#define _SEG24                  0x01
#define _SEG25                  0x02
#define _SEG26                  0x04
#define _SEG27                  0x08
#define _SEG28                  0x10
#define _SEG29                  0x20
#define _SEG30                  0x40
#define _SEG31                  0x80

//==============================================================================


//==============================================================================
//        LCDD04 Bits

extern __at(0x0114) __sfr LCDD04;

typedef struct
  {
  unsigned SEG00                : 1;
  unsigned SEG01                : 1;
  unsigned SEG02                : 1;
  unsigned SEG03                : 1;
  unsigned SEG04                : 1;
  unsigned SEG05                : 1;
  unsigned SEG06                : 1;
  unsigned SEG07                : 1;
  } __LCDD04bits_t;

extern __at(0x0114) volatile __LCDD04bits_t LCDD04bits;

#define _LCDD04_SEG00           0x01
#define _LCDD04_SEG01           0x02
#define _LCDD04_SEG02           0x04
#define _LCDD04_SEG03           0x08
#define _LCDD04_SEG04           0x10
#define _LCDD04_SEG05           0x20
#define _LCDD04_SEG06           0x40
#define _LCDD04_SEG07           0x80

//==============================================================================


//==============================================================================
//        LCDD05 Bits

extern __at(0x0115) __sfr LCDD05;

typedef struct
  {
  unsigned SEG08                : 1;
  unsigned SEG09                : 1;
  unsigned SEG10                : 1;
  unsigned SEG11                : 1;
  unsigned SEG12                : 1;
  unsigned SEG13                : 1;
  unsigned SEG14                : 1;
  unsigned SEG15                : 1;
  } __LCDD05bits_t;

extern __at(0x0115) volatile __LCDD05bits_t LCDD05bits;

#define _LCDD05_SEG08           0x01
#define _LCDD05_SEG09           0x02
#define _LCDD05_SEG10           0x04
#define _LCDD05_SEG11           0x08
#define _LCDD05_SEG12           0x10
#define _LCDD05_SEG13           0x20
#define _LCDD05_SEG14           0x40
#define _LCDD05_SEG15           0x80

//==============================================================================


//==============================================================================
//        LCDD06 Bits

extern __at(0x0116) __sfr LCDD06;

typedef struct
  {
  unsigned SEG16                : 1;
  unsigned SEG17                : 1;
  unsigned SEG18                : 1;
  unsigned SEG19                : 1;
  unsigned SEG20                : 1;
  unsigned SEG21                : 1;
  unsigned SEG22                : 1;
  unsigned SEG23                : 1;
  } __LCDD06bits_t;

extern __at(0x0116) volatile __LCDD06bits_t LCDD06bits;

#define _LCDD06_SEG16           0x01
#define _LCDD06_SEG17           0x02
#define _LCDD06_SEG18           0x04
#define _LCDD06_SEG19           0x08
#define _LCDD06_SEG20           0x10
#define _LCDD06_SEG21           0x20
#define _LCDD06_SEG22           0x40
#define _LCDD06_SEG23           0x80

//==============================================================================


//==============================================================================
//        LCDD07 Bits

extern __at(0x0117) __sfr LCDD07;

typedef struct
  {
  unsigned SEG24                : 1;
  unsigned SEG25                : 1;
  unsigned SEG26                : 1;
  unsigned SEG27                : 1;
  unsigned SEG28                : 1;
  unsigned SEG29                : 1;
  unsigned SEG30                : 1;
  unsigned SEG31                : 1;
  } __LCDD07bits_t;

extern __at(0x0117) volatile __LCDD07bits_t LCDD07bits;

#define _LCDD07_SEG24           0x01
#define _LCDD07_SEG25           0x02
#define _LCDD07_SEG26           0x04
#define _LCDD07_SEG27           0x08
#define _LCDD07_SEG28           0x10
#define _LCDD07_SEG29           0x20
#define _LCDD07_SEG30           0x40
#define _LCDD07_SEG31           0x80

//==============================================================================


//==============================================================================
//        LCDD08 Bits

extern __at(0x0118) __sfr LCDD08;

typedef struct
  {
  unsigned SEG00                : 1;
  unsigned SEG01                : 1;
  unsigned SEG02                : 1;
  unsigned SEG03                : 1;
  unsigned SEG04                : 1;
  unsigned SEG05                : 1;
  unsigned SEG06                : 1;
  unsigned SEG07                : 1;
  } __LCDD08bits_t;

extern __at(0x0118) volatile __LCDD08bits_t LCDD08bits;

#define _LCDD08_SEG00           0x01
#define _LCDD08_SEG01           0x02
#define _LCDD08_SEG02           0x04
#define _LCDD08_SEG03           0x08
#define _LCDD08_SEG04           0x10
#define _LCDD08_SEG05           0x20
#define _LCDD08_SEG06           0x40
#define _LCDD08_SEG07           0x80

//==============================================================================


//==============================================================================
//        LCDD09 Bits

extern __at(0x0119) __sfr LCDD09;

typedef struct
  {
  unsigned SEG08                : 1;
  unsigned SEG09                : 1;
  unsigned SEG10                : 1;
  unsigned SEG11                : 1;
  unsigned SEG12                : 1;
  unsigned SEG13                : 1;
  unsigned SEG14                : 1;
  unsigned SEG15                : 1;
  } __LCDD09bits_t;

extern __at(0x0119) volatile __LCDD09bits_t LCDD09bits;

#define _LCDD09_SEG08           0x01
#define _LCDD09_SEG09           0x02
#define _LCDD09_SEG10           0x04
#define _LCDD09_SEG11           0x08
#define _LCDD09_SEG12           0x10
#define _LCDD09_SEG13           0x20
#define _LCDD09_SEG14           0x40
#define _LCDD09_SEG15           0x80

//==============================================================================


//==============================================================================
//        LCDD10 Bits

extern __at(0x011A) __sfr LCDD10;

typedef struct
  {
  unsigned SEG16                : 1;
  unsigned SEG17                : 1;
  unsigned SEG18                : 1;
  unsigned SEG19                : 1;
  unsigned SEG20                : 1;
  unsigned SEG21                : 1;
  unsigned SEG22                : 1;
  unsigned SEG23                : 1;
  } __LCDD10bits_t;

extern __at(0x011A) volatile __LCDD10bits_t LCDD10bits;

#define _LCDD10_SEG16           0x01
#define _LCDD10_SEG17           0x02
#define _LCDD10_SEG18           0x04
#define _LCDD10_SEG19           0x08
#define _LCDD10_SEG20           0x10
#define _LCDD10_SEG21           0x20
#define _LCDD10_SEG22           0x40
#define _LCDD10_SEG23           0x80

//==============================================================================


//==============================================================================
//        LCDD11 Bits

extern __at(0x011B) __sfr LCDD11;

typedef struct
  {
  unsigned SEG24                : 1;
  unsigned SEG25                : 1;
  unsigned SEG26                : 1;
  unsigned SEG27                : 1;
  unsigned SEG28                : 1;
  unsigned SEG29                : 1;
  unsigned SEG30                : 1;
  unsigned SEG31                : 1;
  } __LCDD11bits_t;

extern __at(0x011B) volatile __LCDD11bits_t LCDD11bits;

#define _LCDD11_SEG24           0x01
#define _LCDD11_SEG25           0x02
#define _LCDD11_SEG26           0x04
#define _LCDD11_SEG27           0x08
#define _LCDD11_SEG28           0x10
#define _LCDD11_SEG29           0x20
#define _LCDD11_SEG30           0x40
#define _LCDD11_SEG31           0x80

//==============================================================================


//==============================================================================
//        LCDD12 Bits

extern __at(0x011C) __sfr LCDD12;

typedef struct
  {
  unsigned SEG00                : 1;
  unsigned SEG01                : 1;
  unsigned SEG02                : 1;
  unsigned SEG03                : 1;
  unsigned SEG04                : 1;
  unsigned SEG05                : 1;
  unsigned SEG06                : 1;
  unsigned SEG07                : 1;
  } __LCDD12bits_t;

extern __at(0x011C) volatile __LCDD12bits_t LCDD12bits;

#define _LCDD12_SEG00           0x01
#define _LCDD12_SEG01           0x02
#define _LCDD12_SEG02           0x04
#define _LCDD12_SEG03           0x08
#define _LCDD12_SEG04           0x10
#define _LCDD12_SEG05           0x20
#define _LCDD12_SEG06           0x40
#define _LCDD12_SEG07           0x80

//==============================================================================


//==============================================================================
//        LCDD13 Bits

extern __at(0x011D) __sfr LCDD13;

typedef struct
  {
  unsigned SEG08                : 1;
  unsigned SEG09                : 1;
  unsigned SEG10                : 1;
  unsigned SEG11                : 1;
  unsigned SEG12                : 1;
  unsigned SEG13                : 1;
  unsigned SEG14                : 1;
  unsigned SEG15                : 1;
  } __LCDD13bits_t;

extern __at(0x011D) volatile __LCDD13bits_t LCDD13bits;

#define _LCDD13_SEG08           0x01
#define _LCDD13_SEG09           0x02
#define _LCDD13_SEG10           0x04
#define _LCDD13_SEG11           0x08
#define _LCDD13_SEG12           0x10
#define _LCDD13_SEG13           0x20
#define _LCDD13_SEG14           0x40
#define _LCDD13_SEG15           0x80

//==============================================================================


//==============================================================================
//        LCDD14 Bits

extern __at(0x011E) __sfr LCDD14;

typedef struct
  {
  unsigned SEG16                : 1;
  unsigned SEG17                : 1;
  unsigned SEG18                : 1;
  unsigned SEG19                : 1;
  unsigned SEG20                : 1;
  unsigned SEG21                : 1;
  unsigned SEG22                : 1;
  unsigned SEG23                : 1;
  } __LCDD14bits_t;

extern __at(0x011E) volatile __LCDD14bits_t LCDD14bits;

#define _LCDD14_SEG16           0x01
#define _LCDD14_SEG17           0x02
#define _LCDD14_SEG18           0x04
#define _LCDD14_SEG19           0x08
#define _LCDD14_SEG20           0x10
#define _LCDD14_SEG21           0x20
#define _LCDD14_SEG22           0x40
#define _LCDD14_SEG23           0x80

//==============================================================================


//==============================================================================
//        LCDD15 Bits

extern __at(0x011F) __sfr LCDD15;

typedef struct
  {
  unsigned SEG24                : 1;
  unsigned SEG25                : 1;
  unsigned SEG26                : 1;
  unsigned SEG27                : 1;
  unsigned SEG28                : 1;
  unsigned SEG29                : 1;
  unsigned SEG30                : 1;
  unsigned SEG31                : 1;
  } __LCDD15bits_t;

extern __at(0x011F) volatile __LCDD15bits_t LCDD15bits;

#define _LCDD15_SEG24           0x01
#define _LCDD15_SEG25           0x02
#define _LCDD15_SEG26           0x04
#define _LCDD15_SEG27           0x08
#define _LCDD15_SEG28           0x10
#define _LCDD15_SEG29           0x20
#define _LCDD15_SEG30           0x40
#define _LCDD15_SEG31           0x80

//==============================================================================


//==============================================================================
//        TRISF Bits

extern __at(0x0187) __sfr TRISF;

typedef struct
  {
  unsigned TRISF0               : 1;
  unsigned TRISF1               : 1;
  unsigned TRISF2               : 1;
  unsigned TRISF3               : 1;
  unsigned TRISF4               : 1;
  unsigned TRISF5               : 1;
  unsigned TRISF6               : 1;
  unsigned TRISF7               : 1;
  } __TRISFbits_t;

extern __at(0x0187) volatile __TRISFbits_t TRISFbits;

#define _TRISF0                 0x01
#define _TRISF1                 0x02
#define _TRISF2                 0x04
#define _TRISF3                 0x08
#define _TRISF4                 0x10
#define _TRISF5                 0x20
#define _TRISF6                 0x40
#define _TRISF7                 0x80

//==============================================================================


//==============================================================================
//        TRISG Bits

extern __at(0x0188) __sfr TRISG;

typedef struct
  {
  unsigned TRISG0               : 1;
  unsigned TRISG1               : 1;
  unsigned TRISG2               : 1;
  unsigned TRISG3               : 1;
  unsigned TRISG4               : 1;
  unsigned TRISG5               : 1;
  unsigned TRISG6               : 1;
  unsigned TRISG7               : 1;
  } __TRISGbits_t;

extern __at(0x0188) volatile __TRISGbits_t TRISGbits;

#define _TRISG0                 0x01
#define _TRISG1                 0x02
#define _TRISG2                 0x04
#define _TRISG3                 0x08
#define _TRISG4                 0x10
#define _TRISG5                 0x20
#define _TRISG6                 0x40
#define _TRISG7                 0x80

//==============================================================================

extern __at(0x018C) __sfr PMDATA;
extern __at(0x018D) __sfr PMADR;
extern __at(0x018E) __sfr PMDATH;
extern __at(0x018F) __sfr PMADRH;

//==============================================================================
//
//        Configuration Bits
//
//==============================================================================

#define _CONFIG1                0x2007

//----------------------------- CONFIG1 Options -------------------------------

#define _FOSC_LP                0x3FFC  // LP oscillator.
#define _LP_OSC                 0x3FFC  // LP oscillator.
#define _FOSC_XT                0x3FFD  // XT oscillator.
#define _XT_OSC                 0x3FFD  // XT oscillator.
#define _FOSC_HS                0x3FFE  // HS oscillator.
#define _HS_OSC                 0x3FFE  // HS oscillator.
#define _FOSC_RC                0x3FFF  // RC oscillator.
#define _RC_OSC                 0x3FFF  // RC oscillator.
#define _WDTE_OFF               0x3FFB  // WDT disabled.
#define _WDT_OFF                0x3FFB  // WDT disabled.
#define _WDTE_ON                0x3FFF  // WDT enabled.
#define _WDT_ON                 0x3FFF  // WDT enabled.
#define _PWRTE_ON               0x3FF7  // PWRT enabled.
#define _PWRTE_OFF              0x3FFF  // PWRT disabled.
#define _CP_ALL                 0x3FCF  // All memory is code protected.
#define _CP_75                  0x3FDF  // 0000h-1EFFh code protected.
#define _CP_50                  0x3FEF  // 0000h-0FFFh code protected.
#define _CP_OFF                 0x3FFF  // Code protection off.
#define _BOREN_OFF              0x3FBF  // BOR disabled.
#define _BODEN_OFF              0x3FBF  // BOR disabled.
#define _BOREN_ON               0x3FFF  // BOR enabled.
#define _BODEN_ON               0x3FFF  // BOR enabled.

//==============================================================================

#define _DEVID1                 0x2006

#define _IDLOC0                 0x2000
#define _IDLOC1                 0x2001
#define _IDLOC2                 0x2002
#define _IDLOC3                 0x2003

//==============================================================================

#ifndef NO_BIT_DEFINES

#define ADON                    ADCON0bits.ADON                 // bit 0
#define GO_NOT_DONE             ADCON0bits.GO_NOT_DONE          // bit 2, shadows bit in ADCON0bits
#define GO                      ADCON0bits.GO                   // bit 2, shadows bit in ADCON0bits
#define NOT_DONE                ADCON0bits.NOT_DONE             // bit 2, shadows bit in ADCON0bits
#define GO_DONE                 ADCON0bits.GO_DONE              // bit 2, shadows bit in ADCON0bits
#define CHS0                    ADCON0bits.CHS0                 // bit 3
#define CHS1                    ADCON0bits.CHS1                 // bit 4
#define CHS2                    ADCON0bits.CHS2                 // bit 5
#define ADCS0                   ADCON0bits.ADCS0                // bit 6
#define ADCS1                   ADCON0bits.ADCS1                // bit 7

#define PCFG0                   ADCON1bits.PCFG0                // bit 0
#define PCFG1                   ADCON1bits.PCFG1                // bit 1
#define PCFG2                   ADCON1bits.PCFG2                // bit 2
#define PCFG3                   ADCON1bits.PCFG3                // bit 3
#define ADFM                    ADCON1bits.ADFM                 // bit 7

#define CCP1M0                  CCP1CONbits.CCP1M0              // bit 0
#define CCP1M1                  CCP1CONbits.CCP1M1              // bit 1
#define CCP1M2                  CCP1CONbits.CCP1M2              // bit 2
#define CCP1M3                  CCP1CONbits.CCP1M3              // bit 3
#define CCP1Y                   CCP1CONbits.CCP1Y               // bit 4
#define CCP1X                   CCP1CONbits.CCP1X               // bit 5

#define RBIF                    INTCONbits.RBIF                 // bit 0
#define INTF                    INTCONbits.INTF                 // bit 1
#define T0IF                    INTCONbits.T0IF                 // bit 2, shadows bit in INTCONbits
#define TMR0IF                  INTCONbits.TMR0IF               // bit 2, shadows bit in INTCONbits
#define RBIE                    INTCONbits.RBIE                 // bit 3
#define INTE                    INTCONbits.INTE                 // bit 4
#define T0IE                    INTCONbits.T0IE                 // bit 5, shadows bit in INTCONbits
#define TMR0IE                  INTCONbits.TMR0IE               // bit 5, shadows bit in INTCONbits
#define PEIE                    INTCONbits.PEIE                 // bit 6
#define GIE                     INTCONbits.GIE                  // bit 7

#define LMUX0                   LCDCONbits.LMUX0                // bit 0
#define LMUX1                   LCDCONbits.LMUX1                // bit 1
#define CS0                     LCDCONbits.CS0                  // bit 2
#define CS1                     LCDCONbits.CS1                  // bit 3
#define VGEN                    LCDCONbits.VGEN                 // bit 4, shadows bit in LCDCONbits
#define BIAS                    LCDCONbits.BIAS                 // bit 4, shadows bit in LCDCONbits
#define WERR                    LCDCONbits.WERR                 // bit 5
#define SLPEN                   LCDCONbits.SLPEN                // bit 6
#define LCDEN                   LCDCONbits.LCDEN                // bit 7

#define SEG00                   LCDD00bits.SEG00                // bit 0
#define SEG01                   LCDD00bits.SEG01                // bit 1
#define SEG02                   LCDD00bits.SEG02                // bit 2
#define SEG03                   LCDD00bits.SEG03                // bit 3
#define SEG04                   LCDD00bits.SEG04                // bit 4
#define SEG05                   LCDD00bits.SEG05                // bit 5
#define SEG06                   LCDD00bits.SEG06                // bit 6
#define SEG07                   LCDD00bits.SEG07                // bit 7

#define SEG08                   LCDD01bits.SEG08                // bit 0
#define SEG09                   LCDD01bits.SEG09                // bit 1
#define SEG10                   LCDD01bits.SEG10                // bit 2
#define SEG11                   LCDD01bits.SEG11                // bit 3
#define SEG12                   LCDD01bits.SEG12                // bit 4
#define SEG13                   LCDD01bits.SEG13                // bit 5
#define SEG14                   LCDD01bits.SEG14                // bit 6
#define SEG15                   LCDD01bits.SEG15                // bit 7

#define SEG16                   LCDD02bits.SEG16                // bit 0
#define SEG17                   LCDD02bits.SEG17                // bit 1
#define SEG18                   LCDD02bits.SEG18                // bit 2
#define SEG19                   LCDD02bits.SEG19                // bit 3
#define SEG20                   LCDD02bits.SEG20                // bit 4
#define SEG21                   LCDD02bits.SEG21                // bit 5
#define SEG22                   LCDD02bits.SEG22                // bit 6
#define SEG23                   LCDD02bits.SEG23                // bit 7

#define SEG24                   LCDD03bits.SEG24                // bit 0
#define SEG25                   LCDD03bits.SEG25                // bit 1
#define SEG26                   LCDD03bits.SEG26                // bit 2
#define SEG27                   LCDD03bits.SEG27                // bit 3
#define SEG28                   LCDD03bits.SEG28                // bit 4
#define SEG29                   LCDD03bits.SEG29                // bit 5
#define SEG30                   LCDD03bits.SEG30                // bit 6
#define SEG31                   LCDD03bits.SEG31                // bit 7

#define LP0                     LCDPSbits.LP0                   // bit 0
#define LP1                     LCDPSbits.LP1                   // bit 1
#define LP2                     LCDPSbits.LP2                   // bit 2
#define LP3                     LCDPSbits.LP3                   // bit 3

#define SE0                     LCDSEbits.SE0                   // bit 0
#define SE5                     LCDSEbits.SE5                   // bit 1
#define SE9                     LCDSEbits.SE9                   // bit 2
#define SE12                    LCDSEbits.SE12                  // bit 3
#define SE16                    LCDSEbits.SE16                  // bit 4
#define SE20                    LCDSEbits.SE20                  // bit 5
#define SE27                    LCDSEbits.SE27                  // bit 6
#define SE29                    LCDSEbits.SE29                  // bit 7

#define PS0                     OPTION_REGbits.PS0              // bit 0
#define PS1                     OPTION_REGbits.PS1              // bit 1
#define PS2                     OPTION_REGbits.PS2              // bit 2
#define PSA                     OPTION_REGbits.PSA              // bit 3
#define T0SE                    OPTION_REGbits.T0SE             // bit 4
#define T0CS                    OPTION_REGbits.T0CS             // bit 5
#define INTEDG                  OPTION_REGbits.INTEDG           // bit 6
#define NOT_RBPU                OPTION_REGbits.NOT_RBPU         // bit 7

#define NOT_BOR                 PCONbits.NOT_BOR                // bit 0
#define NOT_POR                 PCONbits.NOT_POR                // bit 1

#define TMR1IE                  PIE1bits.TMR1IE                 // bit 0
#define TMR2IE                  PIE1bits.TMR2IE                 // bit 1
#define CCP1IE                  PIE1bits.CCP1IE                 // bit 2
#define SSPIE                   PIE1bits.SSPIE                  // bit 3
#define ADIE                    PIE1bits.ADIE                   // bit 6
#define LCDIE                   PIE1bits.LCDIE                  // bit 7

#define TMR1IF                  PIR1bits.TMR1IF                 // bit 0
#define TMR2IF                  PIR1bits.TMR2IF                 // bit 1
#define CCP1IF                  PIR1bits.CCP1IF                 // bit 2
#define SSPIF                   PIR1bits.SSPIF                  // bit 3
#define ADIF                    PIR1bits.ADIF                   // bit 6
#define LCDIF                   PIR1bits.LCDIF                  // bit 7

#define RD                      PMCON1bits.RD                   // bit 0

#define RA0                     PORTAbits.RA0                   // bit 0
#define RA1                     PORTAbits.RA1                   // bit 1
#define RA2                     PORTAbits.RA2                   // bit 2
#define RA3                     PORTAbits.RA3                   // bit 3
#define RA4                     PORTAbits.RA4                   // bit 4
#define RA5                     PORTAbits.RA5                   // bit 5

#define RB0                     PORTBbits.RB0                   // bit 0
#define RB1                     PORTBbits.RB1                   // bit 1
#define RB2                     PORTBbits.RB2                   // bit 2
#define RB3                     PORTBbits.RB3                   // bit 3
#define RB4                     PORTBbits.RB4                   // bit 4
#define RB5                     PORTBbits.RB5                   // bit 5
#define RB6                     PORTBbits.RB6                   // bit 6
#define RB7                     PORTBbits.RB7                   // bit 7

#define RC0                     PORTCbits.RC0                   // bit 0
#define RC1                     PORTCbits.RC1                   // bit 1
#define RC2                     PORTCbits.RC2                   // bit 2
#define RC3                     PORTCbits.RC3                   // bit 3
#define RC4                     PORTCbits.RC4                   // bit 4
#define RC5                     PORTCbits.RC5                   // bit 5

#define RD0                     PORTDbits.RD0                   // bit 0
#define RD1                     PORTDbits.RD1                   // bit 1
#define RD2                     PORTDbits.RD2                   // bit 2
#define RD3                     PORTDbits.RD3                   // bit 3
#define RD4                     PORTDbits.RD4                   // bit 4
#define RD5                     PORTDbits.RD5                   // bit 5
#define RD6                     PORTDbits.RD6                   // bit 6
#define RD7                     PORTDbits.RD7                   // bit 7

#define RE0                     PORTEbits.RE0                   // bit 0
#define RE1                     PORTEbits.RE1                   // bit 1
#define RE2                     PORTEbits.RE2                   // bit 2
#define RE3                     PORTEbits.RE3                   // bit 3
#define RE4                     PORTEbits.RE4                   // bit 4
#define RE5                     PORTEbits.RE5                   // bit 5
#define RE6                     PORTEbits.RE6                   // bit 6
#define RE7                     PORTEbits.RE7                   // bit 7

#define RF0                     PORTFbits.RF0                   // bit 0
#define RF1                     PORTFbits.RF1                   // bit 1
#define RF2                     PORTFbits.RF2                   // bit 2
#define RF3                     PORTFbits.RF3                   // bit 3
#define RF4                     PORTFbits.RF4                   // bit 4
#define RF5                     PORTFbits.RF5                   // bit 5
#define RF6                     PORTFbits.RF6                   // bit 6
#define RF7                     PORTFbits.RF7                   // bit 7

#define RG0                     PORTGbits.RG0                   // bit 0
#define RG1                     PORTGbits.RG1                   // bit 1
#define RG2                     PORTGbits.RG2                   // bit 2
#define RG3                     PORTGbits.RG3                   // bit 3
#define RG4                     PORTGbits.RG4                   // bit 4
#define RG5                     PORTGbits.RG5                   // bit 5
#define RG6                     PORTGbits.RG6                   // bit 6
#define RG7                     PORTGbits.RG7                   // bit 7

#define SSPM0                   SSPCONbits.SSPM0                // bit 0
#define SSPM1                   SSPCONbits.SSPM1                // bit 1
#define SSPM2                   SSPCONbits.SSPM2                // bit 2
#define SSPM3                   SSPCONbits.SSPM3                // bit 3
#define CKP                     SSPCONbits.CKP                  // bit 4
#define SSPEN                   SSPCONbits.SSPEN                // bit 5
#define SSPOV                   SSPCONbits.SSPOV                // bit 6
#define WCOL                    SSPCONbits.WCOL                 // bit 7

#define BF                      SSPSTATbits.BF                  // bit 0
#define UA                      SSPSTATbits.UA                  // bit 1
#define R_NOT_W                 SSPSTATbits.R_NOT_W             // bit 2, shadows bit in SSPSTATbits
#define R                       SSPSTATbits.R                   // bit 2, shadows bit in SSPSTATbits
#define I2C_READ                SSPSTATbits.I2C_READ            // bit 2, shadows bit in SSPSTATbits
#define R_W                     SSPSTATbits.R_W                 // bit 2, shadows bit in SSPSTATbits
#define READ_WRITE              SSPSTATbits.READ_WRITE          // bit 2, shadows bit in SSPSTATbits
#define NOT_W                   SSPSTATbits.NOT_W               // bit 2, shadows bit in SSPSTATbits
#define NOT_WRITE               SSPSTATbits.NOT_WRITE           // bit 2, shadows bit in SSPSTATbits
#define S                       SSPSTATbits.S                   // bit 3, shadows bit in SSPSTATbits
#define I2C_START               SSPSTATbits.I2C_START           // bit 3, shadows bit in SSPSTATbits
#define P                       SSPSTATbits.P                   // bit 4, shadows bit in SSPSTATbits
#define I2C_STOP                SSPSTATbits.I2C_STOP            // bit 4, shadows bit in SSPSTATbits
#define D_NOT_A                 SSPSTATbits.D_NOT_A             // bit 5, shadows bit in SSPSTATbits
#define D                       SSPSTATbits.D                   // bit 5, shadows bit in SSPSTATbits
#define I2C_DATA                SSPSTATbits.I2C_DATA            // bit 5, shadows bit in SSPSTATbits
#define D_A                     SSPSTATbits.D_A                 // bit 5, shadows bit in SSPSTATbits
#define DATA_ADDRESS            SSPSTATbits.DATA_ADDRESS        // bit 5, shadows bit in SSPSTATbits
#define NOT_A                   SSPSTATbits.NOT_A               // bit 5, shadows bit in SSPSTATbits
#define NOT_ADDRESS             SSPSTATbits.NOT_ADDRESS         // bit 5, shadows bit in SSPSTATbits
#define CKE                     SSPSTATbits.CKE                 // bit 6
#define SMP                     SSPSTATbits.SMP                 // bit 7

#define C                       STATUSbits.C                    // bit 0
#define DC                      STATUSbits.DC                   // bit 1
#define Z                       STATUSbits.Z                    // bit 2
#define NOT_PD                  STATUSbits.NOT_PD               // bit 3
#define NOT_TO                  STATUSbits.NOT_TO               // bit 4
#define RP0                     STATUSbits.RP0                  // bit 5
#define RP1                     STATUSbits.RP1                  // bit 6
#define IRP                     STATUSbits.IRP                  // bit 7

#define TMR1ON                  T1CONbits.TMR1ON                // bit 0
#define TMR1CS                  T1CONbits.TMR1CS                // bit 1
#define NOT_T1SYNC              T1CONbits.NOT_T1SYNC            // bit 2, shadows bit in T1CONbits
#define T1INSYNC                T1CONbits.T1INSYNC              // bit 2, shadows bit in T1CONbits
#define T1OSCEN                 T1CONbits.T1OSCEN               // bit 3
#define T1CKPS0                 T1CONbits.T1CKPS0               // bit 4
#define T1CKPS1                 T1CONbits.T1CKPS1               // bit 5

#define T2CKPS0                 T2CONbits.T2CKPS0               // bit 0
#define T2CKPS1                 T2CONbits.T2CKPS1               // bit 1
#define TMR2ON                  T2CONbits.TMR2ON                // bit 2
#define TOUTPS0                 T2CONbits.TOUTPS0               // bit 3
#define TOUTPS1                 T2CONbits.TOUTPS1               // bit 4
#define TOUTPS2                 T2CONbits.TOUTPS2               // bit 5
#define TOUTPS3                 T2CONbits.TOUTPS3               // bit 6

#define TRISA0                  TRISAbits.TRISA0                // bit 0
#define TRISA1                  TRISAbits.TRISA1                // bit 1
#define TRISA2                  TRISAbits.TRISA2                // bit 2
#define TRISA3                  TRISAbits.TRISA3                // bit 3
#define TRISA4                  TRISAbits.TRISA4                // bit 4
#define TRISA5                  TRISAbits.TRISA5                // bit 5

#define TRISB0                  TRISBbits.TRISB0                // bit 0
#define TRISB1                  TRISBbits.TRISB1                // bit 1
#define TRISB2                  TRISBbits.TRISB2                // bit 2
#define TRISB3                  TRISBbits.TRISB3                // bit 3
#define TRISB4                  TRISBbits.TRISB4                // bit 4
#define TRISB5                  TRISBbits.TRISB5                // bit 5
#define TRISB6                  TRISBbits.TRISB6                // bit 6
#define TRISB7                  TRISBbits.TRISB7                // bit 7

#define TRISC0                  TRISCbits.TRISC0                // bit 0
#define TRISC1                  TRISCbits.TRISC1                // bit 1
#define TRISC2                  TRISCbits.TRISC2                // bit 2
#define TRISC3                  TRISCbits.TRISC3                // bit 3
#define TRISC4                  TRISCbits.TRISC4                // bit 4
#define TRISC5                  TRISCbits.TRISC5                // bit 5

#define TRISD0                  TRISDbits.TRISD0                // bit 0
#define TRISD1                  TRISDbits.TRISD1                // bit 1
#define TRISD2                  TRISDbits.TRISD2                // bit 2
#define TRISD3                  TRISDbits.TRISD3                // bit 3
#define TRISD4                  TRISDbits.TRISD4                // bit 4
#define TRISD5                  TRISDbits.TRISD5                // bit 5
#define TRISD6                  TRISDbits.TRISD6                // bit 6
#define TRISD7                  TRISDbits.TRISD7                // bit 7

#define TRISE0                  TRISEbits.TRISE0                // bit 0
#define TRISE1                  TRISEbits.TRISE1                // bit 1
#define TRISE2                  TRISEbits.TRISE2                // bit 2
#define TRISE3                  TRISEbits.TRISE3                // bit 3
#define TRISE4                  TRISEbits.TRISE4                // bit 4, shadows bit in TRISEbits
#define PSPMODE                 TRISEbits.PSPMODE               // bit 4, shadows bit in TRISEbits
#define TRISE5                  TRISEbits.TRISE5                // bit 5, shadows bit in TRISEbits
#define IBOV                    TRISEbits.IBOV                  // bit 5, shadows bit in TRISEbits
#define TRISE6                  TRISEbits.TRISE6                // bit 6, shadows bit in TRISEbits
#define OBF                     TRISEbits.OBF                   // bit 6, shadows bit in TRISEbits
#define TRISE7                  TRISEbits.TRISE7                // bit 7, shadows bit in TRISEbits
#define IBF                     TRISEbits.IBF                   // bit 7, shadows bit in TRISEbits

#define TRISF0                  TRISFbits.TRISF0                // bit 0
#define TRISF1                  TRISFbits.TRISF1                // bit 1
#define TRISF2                  TRISFbits.TRISF2                // bit 2
#define TRISF3                  TRISFbits.TRISF3                // bit 3
#define TRISF4                  TRISFbits.TRISF4                // bit 4
#define TRISF5                  TRISFbits.TRISF5                // bit 5
#define TRISF6                  TRISFbits.TRISF6                // bit 6
#define TRISF7                  TRISFbits.TRISF7                // bit 7

#define TRISG0                  TRISGbits.TRISG0                // bit 0
#define TRISG1                  TRISGbits.TRISG1                // bit 1
#define TRISG2                  TRISGbits.TRISG2                // bit 2
#define TRISG3                  TRISGbits.TRISG3                // bit 3
#define TRISG4                  TRISGbits.TRISG4                // bit 4
#define TRISG5                  TRISGbits.TRISG5                // bit 5
#define TRISG6                  TRISGbits.TRISG6                // bit 6
#define TRISG7                  TRISGbits.TRISG7                // bit 7

#endif // #ifndef NO_BIT_DEFINES

#endif // #ifndef __PIC16C926_H__
